@ECHO OFF
CLS

SETLOCAL ENABLEEXTENSIONS
SETLOCAL ENABLEDELAYEDEXPANSION
IF EXIST usb_prep.log (del usb_prep.log)

(
  ECHO  LogFile - Date = %DATE% %TIME:~0,8%
  ECHO.
  ECHO  Program  -  usb_prep8.cmd  -  01 dec 2007
  ECHO.
  ECHO  Prepares Windows XP Setup LocalSource for Copy to USB-Drive
  ECHO.
  ECHO  *** BEFORE YOU START: ***  Use 2 GB USB-stick with High Read/Write Speed
  echo  First Format to Make Bootable USB-stick with FAT FileSystem, FAT = Faster
  ECHO  such that USB-stick has NTLDR Bootsector and is seen by BIOS as Harddisk 
  ECHO.   
  echo  Use PeToUSB.exe with Settings: Enable Disk Format with LBA FAT16X
  ECHO.
  ECHO  USB-sticks Used with Success for Install of Windows XP in ca 30 minutes:
  ECHO  Apacer HT203 1, 2 and 4 GB
  ECHO  Buffalo FireStix 2GB type R RUF2-R2G-S - 16 min
  ECHO.
  ECHO  OR Use Existing USB-stick with NTLDR Bootsector and Multi BOOT.INI Menu
  ECHO  GUIDE: http://www.911cd.net/forums//index.php?showtopic=20089 
  ECHO.
  ECHO  For AUTOSTART: COPY PeToUSB.exe in your usb_prep folder
  ECHO  http://gocoding.com/page.php?al=petousb
  ECHO. 
  ECHO  For UNATTENDED Install make Changes in usb_prep folder:
  ECHO  Change Product Key in winnt.sif and Change $OEM$ folder to your needs
  ECHO.
  ECHO  FOR USB-Harddisk make 1900 MB partition at beginning of the USB-Harddisk
  ECHO  Use FAT Format and Set Active OR use PeToUSB to Format such partition
  ECHO  rdummy.sys makes Fixed USB-Harddisk seen in XP Setup as Removable Device
  ECHO.
) >> usb_prep.log

ECHO.
ECHO  Program  -  usb_prep8.cmd  -  01 dec 2007 - Date = %DATE% %TIME:~0,8%
ECHO  Prepares Windows XP Setup LocalSource for Copy to USB-Drive
ECHO.
ECHO  *** BEFORE YOU START: ***  Use 2 GB USB-stick with High Read/Write Speed
echo  First Format to Make Bootable USB-stick with FAT FileSystem, FAT = Faster
ECHO  such that USB-stick has NTLDR Bootsector and is seen by BIOS as Harddisk 
ECHO.  
echo  Use PeToUSB.exe with Settings: Enable Disk Format with LBA FAT16X
ECHO.
ECHO  OR Use Existing USB-stick with NTLDR Bootsector and Multi BOOT.INI Menu 
ECHO  GUIDE: http://www.911cd.net/forums//index.php?showtopic=20089 
ECHO.
ECHO  For AUTOSTART: COPY PeToUSB.exe in your usb_prep folder
ECHO  http://gocoding.com/page.php?al=petousb
ECHO.
ECHO  For UNATTENDED Install make Changes in usb_prep folder:
ECHO  Change Product Key in winnt.sif and Change $OEM$ folder to your needs
ECHO.
ECHO  FOR USB-Harddisk make 1900 MB partition at beginning of the USB-Harddisk
ECHO  Use FAT Format and Set Active OR use PeToUSB to Format such partition
ECHO  rdummy.sys makes Fixed USB-Harddisk seen in XP Setup as Removable Device
ECHO.
PAUSE

:: Check Windows version
IF NOT "%OS%"=="Windows_NT" GOTO :_end_quit


IF EXIST PeToUSB.exe ( 
   PeToUSB.exe
   ECHO >> usb_prep.log PeToUSB.exe was launched to FORMAT USB-Drive
)

set usb_type=USB-stick
set xpsource=
set tmpdrive=
set usbdrive=
set usbtemp=
set logtype=Simple

FOR %%i IN (P Q R S T) DO (
  IF not exist %%i:\nul (
  set tmpdrive=%%i:
  )
)


:_main
echo.
echo.
echo  Program  -  usb_prep8.cmd  -  01 dec 2007 - Date = %DATE% %TIME:~0,8%
echo.
echo  Prepares Windows XP LocalSource for Copy to USB-Drive:
echo.
echo     0) Change Type of USB-Drive, currently [%usb_type%]
echo.
echo     1) Change XP Setup Source Path, currently [%xpsource%]
echo.
echo     2) Change Virtual TempDrive, currently [%tmpdrive%]
echo.
echo     3) Change Target USB-Drive Letter, currently [%usbdrive%]
echo.
echo     4) Make New Tempimage with XP LocalSource and Copy to USB-Drive
echo.
echo     5) Use Existing Tempimage with XP LocalSource and Copy to USB-Drive
echo.
echo     F) Change Log File - Simple OR Extended, currently [%logtype%]
echo.
echo     Q) Quit
echo.
echo.
echo.

set _ok=
set /p _ok= Enter your choice: 
if "%_ok%" == "0" goto _getype
if "%_ok%" == "1" goto _getsrc
if "%_ok%" == "2" goto _gettmp
if "%_ok%" == "3" goto _getusb
if "%_ok%" == "4" goto _mktemp
if "%_ok%" == "5" goto _usetemp
if /I "%_ok%" == "f" goto _getlog
if /I "%_ok%" == "q" goto _end_quit
ECHO.
ECHO ***** NOT in Menu - Wrong Selection - Try Again *****
ECHO.
pause
goto :_main

:_getype
IF "%usb_type%" == "USB-stick" (
    set usb_type=USB-Harddisk
) ELSE (
    set usb_type=USB-stick
)
goto _main

:_getlog
IF "%logtype%" == "Simple" (
   set logtype=Extended
) ELSE (
   set logtype=Simple
)
goto _main

:_getsrc
set src_ok=
echo.
echo  Please give the location to your Windows XP Setup Source Files

IF EXIST u_script\FolderSel.vbs (
  FOR /F "tokens=*" %%A IN ('CSCRIPT.EXE //NoLogo u_script\FolderSel.vbs') DO SET src_ok=%%A
) ELSE (
  ECHO  e.g if you have D:\XPSOURCE\I386 type D:\XPSOURCE
  set /p src_ok= Enter Source path: 
)
ECHO.

if exist %src_ok%\i386\winnt32.exe (
        SET xpsource=%src_ok%
) else (
	echo.
	echo  Error: The path %src_ok% does not contain Windows XP Source Files
        echo.
	pause
)
goto _main

:_gettmp
set _ok=
echo.
echo  Give Non existing DriveLetter e.g type T  as Virtual Drive for Tempimage
ECHO.
set /p _ok= Enter Available Virtual DriveLetter: 
set _ok=!_ok:~0,1!
if exist !_ok!:\nul (
        echo.
	echo  **** Drive !_ok!: Exists and is not available as valid Virtual Drive *****
        echo.
	pause
	goto _main
)
FOR %%i IN (F G H I J K L M N O P Q R S T U V W X Y f g h i j k l m n o p q r s t u v w x y) DO IF "%%i" == "!_ok!" SET tmpdrive=!_ok!:
if "%tmpdrive%" == "" ( 
        echo.
        echo  ***** !_ok!: is not a valid Drive *****
        echo.
	pause
	goto _main
)
goto _main

:_getusb
set _ok=
echo.
echo  Please give Target USB-Drive Letter e.g type U
ECHO.
set /p _ok= Enter Target USB-Drive Letter: 
set _ok=!_ok:~0,1!
if not exist !_ok!:\nul (
  echo.
  echo  ***** Target USB-Drive !_ok!: does NOT Exist *****
  echo.
  pause
  goto _main
)

FOR %%i IN (E F G H I J K L M N O P Q R S T U V W X Y e f g h i j k l m n o p q r s t u v w x y) DO IF "%%i" == "!_ok!" SET usbdrive=!_ok!:

if "%usbdrive%" == "" ( 
        echo.
        echo  ***** !_ok!: is not a valid Drive *****
        echo.
	pause
	goto _main
)

if EXIST %usbdrive%\$WIN_NT$.~LS\I386\nul (
        echo.
	echo  ***** WARNING Existing Folder $WIN_NT$.~LS on USB-Drive Detected   *****
        echo  ***** Files will be Replaced when Tempimage is Copied to USB-Drive *****
        echo.
        echo.>> usb_prep.log
	echo >> usb_prep.log  ***** WARNING Existing Folder $WIN_NT$.~LS on USB-Drive Detected   *****
        echo >> usb_prep.log  ***** Files will be Replaced when Tempimage is Copied to USB-Drive *****
        echo.>> usb_prep.log
	pause
)
goto _main

:_usetemp
IF "%usbdrive%" == "" (
        echo.
        echo **** Please give first valid Target USB-Drive Letter Using Menu Option 3 *****
        echo.
	pause
	goto _main
)
ECHO  Closing Existing Virtual Drives if any ....
VDK.EXE STOP
vdk.exe remove
echo  Existing Virtual Drives if any are Closed
ECHO.
echo.>> usb_prep.log
echo >> usb_prep.log Using Existing Tempimage with XP LocalSource for Copy to USB-Drive
echo.>> usb_prep.log
echo >> usb_prep.log Existing Virtual Drives if any are Closed

echo.
echo  Please give the Name of your TempImage File
ECHO.

IF EXIST u_script\FileSel.vbs (
  FOR /F "tokens=*" %%A IN ('CSCRIPT.EXE //NoLogo u_script\FileSel.vbs') DO SET usbtemp=%%A
  if "!usbtemp!" == "" goto _main
) ELSE (
  set /p usbtemp= Enter TempImage FileName - Default is tempimage.img: 
  if "!usbtemp!" == "" (
     set usbtemp=tempimage.img
  )
)

ECHO  Using Existing Tempimage with XP LocalSource FileName = %usbtemp%
IF EXIST !usbtemp! (
   VDK.EXE INSTALL
   VDK.EXE DISK 1
   vdk.exe start
   vdk.exe create
   FOR /F  "tokens=1 delims= " %%A in ('VDK.EXE OPEN 0 !usbtemp! /RW ^| FIND /I "FAT32"') DO (
      SET tmpdrive=%%A
   )
   echo.
   echo  TempImage File !usbtemp! was Mounted as TEMPDRIVE = !tmpdrive!
   ECHO.
   echo.>> usb_prep.log
   echo >> usb_prep.log TempImage File !usbtemp! was Mounted as TEMPDRIVE = !tmpdrive!
   ECHO.>> usb_prep.log
) ELSE (
   echo.
   echo  ***** TempImage File !usbtemp! was not found - ERROR *****
   ECHO.
   echo.>> usb_prep.log
   echo >> usb_prep.log ***** TempImage File !usbtemp! was not found - ERROR *****
   ECHO.>> usb_prep.log
   pause
   goto _main
)
if "!tmpdrive!" == "" (
   ECHO  ***** Drive Letter of TEMPDRIVE was not found - ERROR *****
   ECHO.
   ECHO  Closing Existing Virtual Drives if any ....
   ECHO >> usb_prep.log ***** Drive Letter of TEMPDRIVE was not found - ERROR *****
   ECHO.>> usb_prep.log
   ECHO >> usb_prep.log Closing Existing Virtual Drives if any ....
   VDK.EXE STOP
   vdk.exe remove
   echo  Existing Virtual Drives if any are Closed
   ECHO.
   echo >> usb_prep.log Existing Virtual Drives if any are Closed
   ECHO.>> usb_prep.log
   goto _end_quit
)
if EXIST !tmpdrive!\$WIN_NT$.~LS\nul (
   ECHO  Existing XP LocalSource was found in TEMPDRIVE = !tmpdrive!
   ECHO.
   ECHO >> usb_prep.log Existing XP LocalSource was found in TEMPDRIVE = !tmpdrive!
   ECHO.>> usb_prep.log
   goto _usbcopy
) ELSE (
   ECHO  XP LocalSource was not found in TEMPDRIVE = !tmpdrive! - Return to MAIN Menu
   ECHO.
   ECHO >> usb_prep.log XP LocalSource was not found in TEMPDRIVE = !tmpdrive! - Return to MAIN Menu
   ECHO.>> usb_prep.log
   pause
)
goto _main

:_mktemp
IF "%xpsource%" == "" (
        echo.
        echo  ***** Please give first valid XP Source Path *****
        echo.
	pause
	goto _main
)

IF "%tmpdrive%" == "" (
        echo.
        echo  ***** Please give first valid Virtual TempDrive *****
        echo.
	pause
	goto _main
)

:: In case of possible Drive Letter Conflict, when USB-stick is plugged in after launching program
if exist !tmpdrive!\nul (
  echo.
  echo  Drive !tmpdrive! Exists and is not available as Valid Virtual Drive
  echo  ***** Auto Reset of Drive Letter for TempDrive was Necessary *****
  echo.
  FOR %%i IN (P Q R S T) DO (
    IF not exist %%i:\nul (
      set tmpdrive=%%i:
    )
  )
  pause
  goto _main
)


IF "%usbdrive%" == "" (
        echo.
        echo  ***** Please give first valid Target USB-Drive Letter *****
        echo.
	pause
	goto _main
)

(
echo.
echo  usb_type = %usb_type%
echo  xpsource = %xpsource%
echo  tmpdrive = %tmpdrive%
echo  usbdrive = %usbdrive%
echo.
) >> usb_prep.log

ECHO  Lets prepare a Tempopary Virtual Drive ....

ECHO.
ECHO  Closing Existing Virtual Drives if any ....
VDK.EXE STOP
vdk.exe remove
echo  Existing Virtual Drives if any are Closed
echo >> usb_prep.log Existing Virtual Drives if any are Closed
ECHO.

IF EXIST tempimage.img (
ECHO.
ECHO  ********** Existing tempimage.img File was Found **********
ECHO.

IF EXIST u_script\Msg_DeleteTempImage.vbs (
   FOR /F "tokens=*" %%A IN ('CSCRIPT.EXE //NoLogo u_script\Msg_DeleteTempImage.vbs') DO SET Conf=%%A
   IF "!Conf!"=="6" SET Conf=y
) ELSE (
  ECHO  Would you like to Delete Existing tempimage.img ? 
  ECHO. 
  SET /P Conf= Please enter y/n: 
)

IF /I !Conf!.==y. (
  echo.>> usb_prep.log
  echo >> usb_prep.log ********** Existing tempimage.img File was Found **********
  echo >> usb_prep.log Existing tempimage.img will be Deleted
  ECHO.
  ) ELSE (
    ECHO.
    ECHO  Return to Main Menu, Then First Rename Your tempimage.img File
    ECHO.
    pause
    goto _main
  )
)

IF EXIST tempimage.img (
   del tempimage.img
   echo.
   echo  Existing tempimage.img Deleted
   echo.>> usb_prep.log
   echo >> usb_prep.log Existing tempimage.img Deleted
) ELSE (
   echo.
   echo  tempimage.img was not found, creating a new one ....
   echo.>> usb_prep.log
   echo >> usb_prep.log tempimage.img does NOT EXIST
)

:: ECHO.
:: ECHO  Please enter temporary image size in MB, according to your source size:
:: ECHO e.g.: 1000
:: SET /P imgsize=
:: set /a imgsize*=1024*1024

:: fsutil.exe file createnew tempimage.img %imgsize%

:: Instead of above use fixed imgsize 0f 1 Giga bytes

fsutil.exe file createnew tempimage.img 1000000000

ECHO.
echo.>> usb_prep.log
echo >> usb_prep.log New tempimage.img of 1 Giga bytes was Created
echo.>> usb_prep.log

VDK.EXE INSTALL
VDK.EXE DISK 1
vdk.exe start
vdk.exe create
vdk.exe OPEN 1 tempimage.img  /RW 
vdk.exe link 1 0 %tmpdrive:~0,1%
ECHO.
ECHO  Temporary Virtual Drive %tmpdrive% Created, lets Format it
ECHO >> usb_prep.log Temporary Virtual Drive %tmpdrive% Created
ECHO.
format %tmpdrive% /FS:fat32 /v:TempDrive /Q
ECHO.
IF %ERRORLEVEL% NEQ 0 (
   ECHO  TEMPDRIVE %tmpdrive% Not Formatted - Program will be Ended
   ECHO >> usb_prep.log TEMPDRIVE %tmpdrive% Not Formatted - Program will be Ended
   ECHO.
   ECHO  Closing Existing Virtual Drives if any ....
   VDK.EXE STOP
   vdk.exe remove
   echo  Existing Virtual Drives if any are Closed
   echo >> usb_prep.log Existing Virtual Drives if any are Closed
   ECHO.
   GOTO _end_quit
)
ECHO  Format of TEMPDRIVE %tmpdrive% is FAT32 and Completed
ECHO >> usb_prep.log Virtual Drive TEMPDRIVE %tmpdrive% was Formatted FAT32
ECHO.

ECHO  Creating LocalSource on Temporary Drive, may take a while ( a few minutes )
ECHO.
pause

ECHO  Parse DOSNET.INF for making Windows XP Setup Bootfolder $WIN_NT$.~BT
ECHO.
ECHO.>> usb_prep.log
ECHO.>> usb_prep.log Date = !DATE! !TIME:~0,8!
ECHO >> usb_prep.log Parse DOSNET.INF for making Windows XP Setup Bootfolder $WIN_NT$.~BT
ECHO.>> usb_prep.log

SET xpdir=\I386
SET btdir=$WIN_NT$.~BT

:: Make Destination directories for XP Setup Bootfolder
IF NOT EXIST %tmpdrive%\%btdir%\nul MD %tmpdrive%\%btdir%
IF NOT EXIST %tmpdrive%\%btdir%\system32\nul MD %tmpdrive%\%btdir%\system32

SET cpyflag=0
SET /A dtel=0
FOR /F "tokens=1,2* delims== " %%G IN (%xpsource%\I386\DOSNET.INF) DO (
  SET FTAG=%%G
  IF "!FTAG!"=="[Directories]" ( 
    SET cpyflag=1
  ) ELSE (
    SET FTAG=!FTAG:~0,1!
    IF "!FTAG!"=="[" SET cpyflag=0
    IF "!cpyflag!"=="1" (
      SET /A dtel=!dtel! + 1
      SET __xpdir.!dtel!=%%H
    ) 
  )
)

SET cpyflag=0
FOR /F "tokens=1,2,3* delims=, " %%G IN (%xpsource%\I386\DOSNET.INF) DO (
  SET FTAG=%%G
  SET FTAG=!FTAG:~0,13!
  IF "!FTAG!"=="[FloppyFiles." ( 
    SET cpyflag=1
    IF "%%G"=="[FloppyFiles.x]" SET cpyflag=0
  ) ELSE (
    SET FTAG=!FTAG:~0,1!
    IF "!FTAG!"=="[" SET cpyflag=0
    IF "!cpyflag!"=="1" (
      SET dnum=%%G
      SET dnum=!dnum:~1,1!
      IF "!dnum!"=="1" SET xpdir=%__xpdir.1%
      IF "!dnum!"=="2" SET xpdir=%__xpdir.2%
      IF "!dnum!"=="3" SET xpdir=%__xpdir.3%
      IF "!dnum!"=="4" SET xpdir=%__xpdir.4%
      SET btfile=%%H
      IF "%%I"=="" (
         SET btfile=!btfile:~0,-1!*
         IF "%logtype%" == "Simple" (
           xcopy %xpsource%!xpdir!\!btfile! %tmpdrive%\%btdir% /i /k /y /h
         ) ELSE (
           xcopy %xpsource%!xpdir!\!btfile! %tmpdrive%\%btdir% /i /k /y /h | tee.bat -a usb_prep.log
         )
      ) ELSE (
         IF "%logtype%" == "Simple" (
           copy /y %xpsource%!xpdir!\%%H %tmpdrive%\%btdir%\%%I
         ) ELSE (
           copy /y %xpsource%!xpdir!\%%H %tmpdrive%\%btdir%\%%I | tee.bat -a usb_prep.log
         )
      )
    ) 
  )
)

IF EXIST %tmpdrive%\%btdir%\NTLDR DEL %tmpdrive%\%btdir%\NTLDR
ECHO.
ECHO  Making Windows XP Setup Bootfolder %tmpdrive%\%btdir% - READY
ECHO.>> usb_prep.log
ECHO >> usb_prep.log Making Windows XP Setup Bootfolder %tmpdrive%\%btdir% - READY
ECHO.>> usb_prep.log Date = !DATE! !TIME:~0,8!
ECHO.>> usb_prep.log



ECHO.
ECHO  Copy XPSOURCE folders cmpnents and i386 to TempDrive folder $WIN_NT$.~LS
ECHO.
IF "%logtype%" == "Simple" (
  echo.>> usb_prep.log
  echo >> usb_prep.log Date = !DATE! !TIME:~0,8!
  echo >> usb_prep.log Copy XPSOURCE folders cmpnents and i386 - Begin
  xcopy %xpsource%\i386\*.* %tmpdrive%\$WIN_NT$.~LS\I386\ /i /k /e /y /h
  IF EXIST %xpsource%\cmpnents\nul (
     xcopy %xpsource%\cmpnents\*.* %tmpdrive%\$WIN_NT$.~LS\cmpnents\ /i /k /e /y /h
  )
  echo >> usb_prep.log Copy XPSOURCE folders cmpnents and i386 - Ready
  echo >> usb_prep.log Date = !DATE! !TIME:~0,8!
) ELSE (
  ECHO.
  ECHO  Date = !DATE! !TIME:~0,8!     
  ECHO  Please Wait .....      Copy XPSOURCE folders cmpnents and i386 is Running .... 
  echo.>> usb_prep.log
  echo >> usb_prep.log Date = !DATE! !TIME:~0,8!
  echo >> usb_prep.log Copy XPSOURCE folders cmpnents and i386 - Begin
  xcopy %xpsource%\i386\*.* %tmpdrive%\$WIN_NT$.~LS\I386\ /i /k /e /y /h | tee.bat -a usb_prep.log
  IF EXIST %xpsource%\cmpnents\nul (
     xcopy %xpsource%\cmpnents\*.* %tmpdrive%\$WIN_NT$.~LS\cmpnents\ /i /k /e /y /h | tee.bat -a usb_prep.log
  )
  echo >> usb_prep.log Copy XPSOURCE folders cmpnents and i386 - Ready
  echo >> usb_prep.log Date = !DATE! !TIME:~0,8!
  echo  Copy XPSOURCE folders cmpnents and i386 to folder $WIN_NT$.~LS - Ready
)

ECHO.
ECHO  Making of LocalSource folder $WIN_NT$.~LS Ready
ECHO.
( 
  ECHO.
  ECHO  Making of LocalSource folder $WIN_NT$.~LS Ready
  ECHO.
) >> usb_prep.log
pause
ECHO  Copying Custom files and XP Root files to temp drive ....
ECHO.
xcopy binifix4.cmd %tmpdrive%\$WIN_NT$.~LS\I386 | tee.bat -a usb_prep.log
ECHO.>> usb_prep.log
ECHO.
xcopy migrate.inf %tmpdrive%\$WIN_NT$.~BT\ /y | tee.bat -a usb_prep.log
ECHO.>> usb_prep.log
ECHO.
IF EXIST %xpsource%\OEM\bin\DPsFnshr.7z (
  copy /y winnt_dp.sif %tmpdrive%\$WIN_NT$.~BT\winnt.sif | tee.bat -a usb_prep.log
) ELSE (
  copy /y winnt.sif %tmpdrive%\$WIN_NT$.~BT\winnt.sif | tee.bat -a usb_prep.log
)
ECHO.>> usb_prep.log
ECHO.
xcopy ren_fold.cmd %tmpdrive%\$WIN_NT$.~LS\I386 | tee.bat -a usb_prep.log
ECHO.>> usb_prep.log
ECHO.
xcopy undoren.cmd %tmpdrive%\$WIN_NT$.~LS\I386 | tee.bat -a usb_prep.log
ECHO.>> usb_prep.log
ECHO.
xcopy boot.ini %tmpdrive%\ /y /r /h | tee.bat -a usb_prep.log
ECHO.>> usb_prep.log
ECHO.
xcopy %xpsource%\i386\txtsetup.sif %tmpdrive%\ /y /r /h | tee.bat -a usb_prep.log
ECHO.>> usb_prep.log
ECHO.
xcopy %xpsource%\i386\bootfont.bin %tmpdrive%\ /y /r /h | tee.bat -a usb_prep.log
ECHO.>> usb_prep.log
ECHO.
xcopy %xpsource%\i386\ntdetect.com %tmpdrive%\ /y /r /h | tee.bat -a usb_prep.log
ECHO.>> usb_prep.log
ECHO.
xcopy %xpsource%\i386\ntldr %tmpdrive%\ /y /r /h | tee.bat -a usb_prep.log
ECHO.>> usb_prep.log
ECHO.
xcopy %xpsource%\i386\setupldr.bin %tmpdrive%\ /y /r /h | tee.bat -a usb_prep.log
ECHO.>> usb_prep.log
ECHO.
ECHO >> usb_prep.log Custom files and XP Root files Copied to temp drive Ready
ECHO.>> usb_prep.log

ECHO.
ECHO  Adding lines to TXTSETUP.SIF ....

fedit -f %tmpdrive%\txtsetup.sif -add -once -l "ren_fold.cmd = 100,,,,,,_x,2,0,0" -s SourceDisksFiles
fedit -f %tmpdrive%\txtsetup.sif -add -once -l "undoren.cmd = 100,,,,,,_x,2,0,0" -s SourceDisksFiles
fedit -f %tmpdrive%\txtsetup.sif -add -once -l "binifix4.cmd = 100,,,,,,_x,2,0,0" -s SourceDisksFiles

:: Added for USB hard drives, loads rdummy.sys during Text Setup, which makes usbstor to see USB HD-drives as removable
IF "%usb_type%" == "USB-Harddisk" (
   fedit -f %tmpdrive%\txtsetup.sif -add -once -l "rdummy.sys = 1,,,,,,4_,4,1,,,1,4" -s SourceDisksFiles
   fedit -f %tmpdrive%\txtsetup.sif -add -once -l "rdummy = rdummy.sys,4" -s SCSI.Load
   fedit -f %tmpdrive%\txtsetup.sif -add -once -l "rdummy = \"USB hard disk as removable\"" -s SCSI
   fedit -f %tmpdrive%\$WIN_NT$.~BT\winnt.sif -add -create -l "\"sc config rdummy start= disabled"" -s GuiRunOnce
   ECHO >> usb_prep.log Adding rdummy.sy_ to make Fixed USB-Harddisk seen in XP Setup as Removable Device
   copy rdummy.sy_ %tmpdrive%\$WIN_NT$.~LS\I386 | tee.bat -a usb_prep.log
   copy rdummy.sy_ %tmpdrive%\$WIN_NT$.~BT | tee.bat -a usb_prep.log
)

ECHO.>> usb_prep.log
ECHO >> usb_prep.log Adding lines to TXTSETUP.SIF Ready

ECHO.
ECHO  Adding lines to WINNT.SIF ....

fedit -f %tmpdrive%\$WIN_NT$.~BT\winnt.sif -add -create -l "\"undoren.cmd"" -s GuiRunOnce
fedit -f %tmpdrive%\$WIN_NT$.~BT\winnt.sif -add -create -l "\"binifix4.cmd c:"" -s GuiRunOnce
fedit -f %tmpdrive%\$WIN_NT$.~BT\winnt.sif -add -create -l "UserExecute = \"ren_fold.cmd\"" -s SetupParams
fedit -f %tmpdrive%\$WIN_NT$.~BT\winnt.sif -rem -l:o = -s unattended
fedit -f %tmpdrive%\$WIN_NT$.~BT\winnt.sif -rem -l [unattended]
ECHO.
ECHO.>> usb_prep.log
ECHO >> usb_prep.log Adding lines to WINNT.SIF Ready
ECHO.>> usb_prep.log

:: $OEM$\CMDLINES.TXT is used for making UserAccounts and install of Registry Tweaks at T-12
:: Info see: http://unattended.msfn.org/unattended.xp/   Reference

ECHO  Adding $OEM$ folder with UserAccounts and Registry Tweaks if present ....
IF NOT EXIST %tmpdrive%\$WIN_NT$.~LS\$OEM$\CMDLINES.TXT (
   IF EXIST $OEM$\nul (
      xcopy $OEM$\*.* %tmpdrive%\$WIN_NT$.~LS\$OEM$\ /i /k /e /y /h | tee.bat -a usb_prep.log
      ECHO >> usb_prep.log Adding $OEM$ folder with UserAccounts and Registry Tweaks Ready
   )
) ELSE (
    ECHO  $OEM$ folder not ADDED, EXISTING $OEM$ folder detected
    ECHO >> usb_prep.log $OEM$ folder not ADDED, EXISTING $OEM$ folder detected
)
ECHO.

ECHO  Adding OEM folder with BTS DriverPacks if they were used ....
IF EXIST %xpsource%\OEM\bin\DPsFnshr.7z (
   ECHO.>> usb_prep.log
   xcopy %xpsource%\OEM %tmpdrive%\OEM /i /k /e /y /h | tee.bat -a usb_prep.log
   echo >> usb_prep.log Adding OEM folder with BTS DriverPacks Ready
   ECHO.>> usb_prep.log
)


IF EXIST %tmpdrive%\$WIN_NT$.~LS\I386\presetup.cmd (
   ECHO  Adding Custom presetup.cmd for BTS DriverPacks ....
   copy /y %tmpdrive%\$WIN_NT$.~LS\I386\presetup.cmd %tmpdrive%\$WIN_NT$.~LS\I386\presetup_cmd.bak | tee.bat -a usb_prep.log
   echo.>> usb_prep.log
   xcopy presetup.cmd %tmpdrive%\$WIN_NT$.~LS\I386\ /y | tee.bat -a usb_prep.log
   ECHO.>> usb_prep.log
   ECHO >> usb_prep.log Adding Custom presetup.cmd for BTS DriverPacks Ready
   ECHO >> usb_prep.log presetup.cmd could give Windows ERROR Alert: No Disk due to Cardreader, Use Continue XP Setup
   ECHO >> usb_prep.log presetup.cmd was changed to limit the range for Finding Drives with OEM TAGFILE
   ECHO >> usb_prep.log presetup.cmd was changed to Delete setupold.exe , necessary for Repair Install Windows XP option
)


:_usbcopy
if EXIST %usbdrive%\$WIN_NT$.~LS\nul (
  ECHO.
  ECHO  Copy TempDrive Files to USB-Drive in about 15 minutes  Continue   Enter Y
  ECHO  Update USB-Drive use Total Commander Synchronize Dirs  END PROGR  Enter N
  ECHO. 
  ECHO.>> usb_prep.log 
  ECHO >> usb_prep.log  Copy TempDrive Files to USB-Drive in about 15 minutes  Continue   Enter Y
  ECHO >> usb_prep.log  Update USB-Drive Use Total Commander Synchronize Dirs  END PROGR  Enter N
  ECHO.>> usb_prep.log
  IF EXIST u_script\Msg_UpdateUSBdrive.vbs (
     FOR /F "tokens=*" %%A IN ('CSCRIPT.EXE //NoLogo u_script\Msg_UpdateUSBdrive.vbs') DO SET Conf=%%A
     IF "!Conf!"=="7" SET Confirm=n
  ) ELSE (
    SET /P Confirm= Continue ?  Please enter y/n: 
  )
  IF /I !Confirm!.==n. GOTO _end_quit
) ELSE (
  ECHO.
  ECHO  Copy TempDrive Files to USB-Drive in about 15 minutes  Enter Y
  ECHO  No Copy of TempDrive Files to USB-Drive,  END PROGRAM  Enter N
  ECHO. 
  ECHO.>> usb_prep.log 
  ECHO >> usb_prep.log  Copy TempDrive Files to USB-Drive in about 15 minutes  Enter Y
  ECHO >> usb_prep.log  No Copy of TempDrive Files to USB-Drive,  END PROGRAM  Enter N
  ECHO.>> usb_prep.log
  IF EXIST u_script\Msg_CopyToUSBdrive.vbs (
     FOR /F "tokens=*" %%A IN ('CSCRIPT.EXE //NoLogo u_script\Msg_CopyToUSBdrive.vbs') DO SET Conf=%%A
     IF "!Conf!"=="7" SET Confirm=n
  ) ELSE (
    SET /P Confirm= Continue ?  Please enter y/n: 
  )
  IF /I !Confirm!.==n. GOTO _end_vdrive
)
ECHO.

ECHO  Making Backups on USB-Drive and Preparing for FileCopy ....
ECHO.>> usb_prep.log
ECHO >> usb_prep.log Making Backups on USB-Drive and Preparing for FileCopy ....
ECHO.>> usb_prep.log

IF EXIST %usbdrive%\boot.ini (
   ATTRIB -h -r -s %usbdrive%\boot.ini
   copy /y %usbdrive%\boot.ini %usbdrive%\boot_ini_bak.txt | tee.bat -a usb_prep.log
   ECHO.>> usb_prep.log
   ECHO >> usb_prep.log Manually Use Later boot_ini_bak.txt to Correct Your Multi boot.ini on USB-Drive
   ECHO.
   ECHO  Manually Use Later boot_ini_bak.txt to Correct Your Multi boot.ini on USB-Drive
   ECHO.>> usb_prep.log
)
IF EXIST %usbdrive%\Bootfont.bin ATTRIB -h -r -s %usbdrive%\Bootfont.bin
IF EXIST %usbdrive%\NTDETECT.COM ATTRIB -h -r -s %usbdrive%\NTDETECT.COM
IF EXIST %usbdrive%\ntldr ATTRIB -h -r -s %usbdrive%\ntldr
IF EXIST %usbdrive%\SETUPLDR.BIN (
   ATTRIB -h -r -s %usbdrive%\SETUPLDR.BIN
   copy /y %usbdrive%\SETUPLDR.BIN %usbdrive%\SETUPLDR_BIN.bak | tee.bat -a usb_prep.log
   ECHO.>> usb_prep.log
)
IF EXIST %usbdrive%\txtsetup.sif (
   ATTRIB -h -r -s %usbdrive%\txtsetup.sif
   copy /y %usbdrive%\txtsetup.sif %usbdrive%\txtsetup_sif.bak | tee.bat -a usb_prep.log
   ECHO.>> usb_prep.log
)
IF EXIST %usbdrive%\BackupBS.ori (
   ATTRIB -h -r -s %usbdrive%\BackupBS.ori
   copy /y %usbdrive%\BackupBS.ori %usbdrive%\BackupBS_ori.bak | tee.bat -a usb_prep.log
   ECHO.>> usb_prep.log
   del %usbdrive%\BackupBS.ori
)
IF EXIST %usbdrive%\SETUPLDR.bs (
   ATTRIB -h -r -s %usbdrive%\SETUPLDR.bs
   copy /y %usbdrive%\SETUPLDR.bs %usbdrive%\SETUPLDR_bs.bak | tee.bat -a usb_prep.log
   ECHO.>> usb_prep.log
)

:: ECHO  Copy to USB-Drive Start - Date = %DATE% %TIME:~0,8%
:: ECHO.
:: ECHO >> usb_prep.log Copy to USB-Drive Start - Date = %DATE% %TIME:~0,8%
:: ECHO.>> usb_prep.log

:: if EXIST %usbdrive%\$WIN_NT$.~LS\nul (
::    echo.>> usb_prep.log
::    echo >> usb_prep.log Existing Folder $WIN_NT$.~LS on USB-Drive will be Deleted
::    ECHO Existing Folder $WIN_NT$.~LS on USB-Drive will be Deleted, STOP with [Ctrl][C]
::    pause
::    ECHO Existing $WIN_NT$.~LS folder is being Deleted from USB-Drive Please Wait ....
::    rd /S /Q %usbdrive%\$WIN_NT$.~LS
::    echo.
::    echo Existing LocalSource Folder $WIN_NT$.~LS Deleted
::    echo.>> usb_prep.log
::    echo >> usb_prep.log Existing LocalSource Folder $WIN_NT$.~LS Deleted
:: )

:: if EXIST %usbdrive%\$WIN_NT$.~BT\nul (
::    echo.>> usb_prep.log
::    echo >> usb_prep.log Existing Folder $WIN_NT$.~BT on USB-Drive will be Deleted
::    ECHO Existing Folder $WIN_NT$.~BT on USB-Drive will be Deleted, STOP with [Ctrl][C]
::    pause
::    ECHO Existing $WIN_NT$.~BT folder is being Deleted from USB-Drive Please Wait .... 
::    rd /S /Q %usbdrive%\$WIN_NT$.~BT
::    echo.
::    echo Existing LocalSource Folder $WIN_NT$.~BT Deleted
::    echo.>> usb_prep.log
::    echo >> usb_prep.log Existing LocalSource Folder $WIN_NT$.~BT Deleted
:: )

ECHO.
ECHO  FileCopy to USB-Drive Start - Date = %DATE% %TIME:~0,8%
ECHO.>> usb_prep.log
ECHO >> usb_prep.log FileCopy to USB-Drive Start - Date = %DATE% %TIME:~0,8%
ECHO.
xcopy %tmpdrive%\*.* %usbdrive%\  /k /y /h | tee.bat -a usb_prep.log
ECHO.>> usb_prep.log
echo >> usb_prep.log Root Files Copy to USB-Drive Ready
echo.
echo  Root Files Copy to USB-Drive Ready
ECHO.
ECHO  Add entry in BOOT.INI to launch TXT Mode Setup ....
CALL makeBS.cmd %usbdrive%\setupldr.bin /a "1. TXT Mode Setup Windows XP, Never unplug USB-Drive Until After Logon"
echo.>> usb_prep.log
ECHO >> usb_prep.log Add entry in BOOT.INI to launch TXT Mode Setup - MakeBS Ready
ECHO.>> usb_prep.log
ECHO.

IF "%logtype%" == "Simple" (
  echo >> usb_prep.log $WIN_NT$.~BT Folder   Copy to USB-Drive Begin   Date = !DATE! !TIME:~0,8!
  xcopy %tmpdrive%\$WIN_NT$.~BT\*.* %usbdrive%\$WIN_NT$.~BT\ /i /k /e /y /h
  echo >> usb_prep.log $WIN_NT$.~BT Folder   Copy to USB-Drive Ready   Date = !DATE! !TIME:~0,8!
  ECHO.>> usb_prep.log
  echo.
  echo  $WIN_NT$.~BT Folder   Copy to USB-Drive Ready
  ECHO.
) ELSE (
  ECHO  Date = !DATE! !TIME:~0,8!
  ECHO  $WIN_NT$.~BT Folder                 Copy to USB-Drive is Running ....
  ECHO  Please Wait about 5 minutes .....   STOP with [Ctrl][C] 
  echo >> usb_prep.log $WIN_NT$.~BT Folder   Copy to USB-Drive Begin   Date = !DATE! !TIME:~0,8!
  xcopy %tmpdrive%\$WIN_NT$.~BT\*.* %usbdrive%\$WIN_NT$.~BT\ /i /k /e /y /h | tee.bat -a usb_prep.log
  echo >> usb_prep.log $WIN_NT$.~BT Folder   Copy to USB-Drive Ready   Date = !DATE! !TIME:~0,8!
  ECHO.>> usb_prep.log
  echo.
  echo  $WIN_NT$.~BT Folder   Copy to USB-Drive Ready
  ECHO.
)

IF "%logtype%" == "Simple" (
  echo >> usb_prep.log $WIN_NT$.~LS Folder   Copy to USB-Drive Begin   Date = !DATE! !TIME:~0,8!
  xcopy %tmpdrive%\$WIN_NT$.~LS\*.* %usbdrive%\$WIN_NT$.~LS\ /i /k /e /y /h
  echo >> usb_prep.log $WIN_NT$.~LS Folder   Copy to USB-Drive Ready   Date = !DATE! !TIME:~0,8!
  ECHO.>> usb_prep.log
  echo.
  echo  $WIN_NT$.~LS Folder   Copy to USB-Drive Ready
  ECHO.
) ELSE (
  ECHO  Date = !DATE! !TIME:~0,8!
  ECHO  $WIN_NT$.~LS Folder                 Copy to USB-Drive is Running ....
  ECHO  Please Wait about 15 minutes .....  STOP with [Ctrl][C] 
  echo >> usb_prep.log $WIN_NT$.~LS Folder   Copy to USB-Drive Begin   Date = !DATE! !TIME:~0,8!
  xcopy %tmpdrive%\$WIN_NT$.~LS\*.* %usbdrive%\$WIN_NT$.~LS\ /i /k /e /y /h | tee.bat -a usb_prep.log
  echo >> usb_prep.log $WIN_NT$.~LS Folder   Copy to USB-Drive Ready   Date = !DATE! !TIME:~0,8!
  ECHO.>> usb_prep.log
  echo.
  echo  $WIN_NT$.~LS Folder   Copy to USB-Drive Ready
  ECHO.
)

IF EXIST %tmpdrive%\OEM\nul (
   xcopy %tmpdrive%\OEM\*.* %usbdrive%\OEM\ /i /k /e /y /h | tee.bat -a usb_prep.log
   echo >> usb_prep.log OEM Folder Copy to USB-Drive Ready
   echo.>> usb_prep.log
)
ECHO.
ECHO  FileCopy to USB-Drive is Ready - Date = %DATE% %TIME:~0,8%
ECHO.>> usb_prep.log
ECHO >> usb_prep.log FileCopy to USB-Drive is Ready - Date = %DATE% %TIME:~0,8%
ECHO.
ECHO  Would you like USB-stick to be Preferred Boot Drive U:  Enter: y
ECHO  In that case migrate.inf is changed with MkMigrateInf2.cmd
ECHO.
ECHO  For Mixed SATA / PATA Config: Don't change migrate.inf  Enter: n
ECHO  For Bootable USB-Harddisk   : Don't change migrate.inf
ECHO.
IF EXIST u_script\Msg_Migrate.vbs (
   FOR /F "tokens=*" %%A IN ('CSCRIPT.EXE //NoLogo u_script\Msg_Migrate.vbs') DO SET Conf=%%A
   IF "!Conf!"=="6" SET Confirm=y
) ELSE (
  SET /P Confirm= Please enter y/n: 
)

IF /I %Confirm%.==y. (
   echo.>> usb_prep.log
   copy /y %usbdrive%\$WIN_NT$.~BT\migrate.inf %usbdrive%\$WIN_NT$.~BT\migrate_inf_bak.txt | tee.bat -a usb_prep.log
   CALL MkMigrateInf2.cmd %usbdrive% %usbdrive%\$WIN_NT$.~BT\migrate.inf
   echo.>> usb_prep.log
   echo >> usb_prep.log USB-Drive becomes Boot Drive U: - MkMigrateInf2 Ready
   echo.>> usb_prep.log
) 
GOTO _end_vdrive

:_end_vdrive
ECHO.
ECHO  Would you like to unmount the Virtual Drive ? 
ECHO. 
IF EXIST u_script\Msg_Unmount.vbs (
   FOR /F "tokens=*" %%A IN ('CSCRIPT.EXE //NoLogo u_script\MSG_Unmount.vbs') DO SET Conf=%%A
   IF "!Conf!"=="6" SET Confirm=y
) ELSE (
  SET /P Confirm= Please enter y/n: 
)
IF /I %Confirm%.==y. (
  VDK.EXE STOP
  vdk.exe remove
  echo.>> usb_prep.log
  echo >> usb_prep.log Virtual Drive Removed
  ECHO.
)

:_end_quit
ECHO. 
ECHO. 
ECHO. 
ECHO  ***** HELP for Using USB-Drive for Install of Windows XP: *****
ECHO. 
ECHO  Boot with USB-Drive plugged and Press [Delete] to Enter BIOS Setup
ECHO  Change BIOS Boot Settings: 
ECHO  Harddisk is First Boot Device Type and USB-Drive is seen as First Harddisk
ECHO. 
ECHO  Reboot from USB-Drive and Select  1. TXT Mode Setup Windows XP
ECHO. 
ECHO  Use Only C: Drive of Computer Harddisk as Partition for Install of Windows XP
ECHO  and then Select Quick Format with NTFS FileSystem, XP Install is Automatic
ECHO. 
ECHO  ***** NEVER UNPLUG USB-Drive ***** Until After First Logon of Windows XP
ECHO.
ECHO  New Harddisk and Creating Partitions after Booting from USB-Drive:
ECHO  Direct after Deleting and Creating New partitions, Quit XP Setup with F3 
ECHO  OR Switch OFF your Computer and Boot in any case from USB-Drive again and 
ECHO  Run 1. TXT Mode Setup again so that DriveLetters get their Correct Value
ECHO  So in this case one Boots ** TWICE ** in the TXT-mode Setup
ECHO. 
ECHO  ***** More Info: Read the Help_usb_prep.txt File *****
ECHO. 

(
  ECHO.
  ECHO ***** HELP for Using USB-Drive for Install of Windows XP: *****
  ECHO.
  ECHO Boot with USB-Drive plugged and Press [Delete] to Enter BIOS Setup
  ECHO Change BIOS Boot Settings: 
  ECHO Harddisk is First Boot Device Type and USB-Drive is seen as First Harddisk
  ECHO.
  ECHO Reboot from USB-Drive and Select  1. TXT Mode Setup Windows XP
  ECHO.
  ECHO Use Only C: Drive of Computer Harddisk as Partition for Install of Windows XP
  ECHO and then Select Quick Format with NTFS FileSystem, XP Install is Automatic
  ECHO.
  ECHO ***** NEVER UNPLUG USB-Drive ***** Until After First Logon of Windows XP
  ECHO.
  ECHO New Harddisk and Creating Partitions after Booting from USB-Drive:
  ECHO Direct after Deleting and Creating New partitions, Quit XP Setup with F3 
  ECHO OR Switch OFF your Computer and Boot in any case from USB-Drive again and 
  ECHO Run 1. TXT Mode Setup again so that DriveLetters get their Correct Value
  ECHO So in this case one Boots ** TWICE ** in the TXT-mode Setup
  ECHO.
  ECHO ***** More Info: Read the Help_usb_prep.txt File *****
  ECHO.
) >> usb_prep.log

PAUSE
ECHO.
ECHO  End Program - USB_PREP.CMD will be Closed - Date = %DATE% %TIME:~0,8%
ECHO.
ECHO.>> usb_prep.log
ECHO >> usb_prep.log End Program - USB_PREP.CMD will be Closed - Date = %DATE% %TIME:~0,8%
ECHO.>> usb_prep.log
pause
EXIT
